<?php

namespace Ignite\HelixCatalog\Listeners;

use GuzzleHttp\Exception\GuzzleException;
use Ignite\Core\Events\ImpersonationStarted;

class ImpersonateHelixUser extends Sync
{
    /**
     * Handle the event.
     *
     * @param ImpersonationStarted $event
     *
     * @return void
     * @throws GuzzleException
     * @see \Ignite\Vendor\Helix\Laravel\Listeners\SyncOnLogin
     */
    public function handle(ImpersonationStarted $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        $this->session->handle($this->request, $this->user($event->impersonated));
    }
}
