<?php

namespace Ignite\HelixCatalog\Listeners;

use Ignite\HelixCatalog\Entities\User;
use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;

abstract class Sync
{
    /**
     * @var Session
     */
    protected $session;

    /**
     * @var Request
     */
    protected $request;

    /**
     * Create the event listener.
     *
     * @param Session $session
     * @param Request $request
     */
    public function __construct(Session $session, Request $request)
    {
        $this->session = $session;
        $this->request = $request;
    }

    /**
     * Convert the user model.
     *
     * @param User|\Ignite\Core\Entities\User|Authenticatable $user
     *
     * @return Model|User|Authenticatable|\Ignite\Core\Entities\User
     */
    protected function user($user)
    {
        return $this->createModel(config('helix.user.model'))->newQuery()->whereKey($user->getKey())->first();
    }

    /**
     * Create a new instance of the model.
     *
     * @param string|\Illuminate\Database\Eloquent\Model $model
     *
     * @return \Illuminate\Database\Eloquent\Model
     */
    protected function createModel($model)
    {
        $class = '\\'.ltrim($model, '\\');

        return new $class;
    }
}
