<?php

namespace Ignite\HelixCatalog\Providers;

use Ignite\HelixCatalog\Listeners\UpdateShippingOrderStatus;
use Ignite\HelixCatalog\Listeners\StoreOrderDetails;
use Ignite\HelixCatalog\Listeners\ImpersonateHelixUser;
use Ignite\Vendor\Helix\Laravel\Events\OrderResourceCreated;
use Ignite\Vendor\Helix\Laravel\Events\WebhookResourceCreated;
use Ignite\Core\Events\ImpersonationStarted;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        OrderResourceCreated::class => [
            StoreOrderDetails::class
        ],
        WebhookResourceCreated::class => [
            UpdateShippingOrderStatus::class
        ],
        ImpersonationStarted::class => [
            ImpersonateHelixUser::class,
        ]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
