<?php

namespace Ignite\HelixCatalog\Listeners;

use Ignite\Core\Events\ImpersonationStarted;
use Ignite\HelixCatalog\Entities\User;
use Ignite\Vendor\Helix\Laravel\Events\WebhookResourceCreated;
use Ignite\Vendor\Helix\Laravel\Sso\Session;
use Illuminate\Http\Request;

class ImpersonateHelixUser
{

    /**
     * @var Session
     */
    private $session;

    /**
     * @var Request
     */
    private $request;

    /**
     * Create the event listener.
     *
     * @param Session $session
     * @param Request $request
     */
    public function __construct(Session $session, Request $request)
    {
        $this->session = $session;
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param WebhookResourceCreated $event
     *
     * @return void
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @see \Ignite\Vendor\Helix\Laravel\Listeners\SyncOnLogin
     */
    public function handle(ImpersonationStarted $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        $user = User::query()->whereKey($event->impersonated->getKey())->first();

        $this->session->handle($this->request, $user);
    }
}
