<?php

namespace Ignite\HelixCatalog\Emails;

use Ignite\HelixCatalog\Entities\Shipment;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Ignite\Catalog\Entities\Order;
use Ignite\Core\Entities\User;

class OrderShipped extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var Order
     */
    private $order;

    /**
     * @var Shipment
     */
    private $shipment;

    /**
     * Create a new order submitted message instance.
     *
     * @param Order $order
     * @param Shipment $shipment
     * @param string $locale
     */
    public function __construct($order, $shipment)
    {
        $this->order = $order;
        $this->shipment = $shipment;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if (! $this->order->relationLoaded('items')) {
            $this->order->load('items');
        }

        if (! $this->order->relationLoaded('participant')) {
            $this->order->load('participant');
        }

        $appName = config('app.name');

        //$this->to($this->order->participant->email, $this->order->participant->fullName());
        $this->subject("{$appName} - Your order #{$this->order->number} has shipped!");
        $this->from(config('mail.from.address'), config('mail.from.name'));
        $this->bcc(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown("emails.orders.shipped", [
            'first_name' => $this->order->participant->first,
            'last_name' => $this->order->participant->last,
            'email' => $this->order->participant->email,
            'order' => $this->order,
            'carrier' => $this->shipment->carrier()
        ]);
    }
}
