<?php

namespace Ignite\HelixCatalog\Entities;

use Ignite\Catalog\Entities\Order;
use Ignite\Vendor\Helix\Laravel\Carriers\Factory;
use Ignite\Vendor\Helix\Laravel\Resources\Webhook;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Shipment
 *
 * @property int $id
 * @property int $order_id
 * @property Order $order
 * @property string $carrier
 * @property string $tracking_number
 * @property string $notes
 * @property \Carbon\Carbon $ship_date
 * @property \Carbon\Carbon $created_at
 * @property \Carbon\Carbon $updated_at
 */
class Shipment extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'helix_shipments';

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'ship_date'
    ];

    /**
     * The relationship to the order model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id');
    }

    /**
     * The carrier instance derived from the current shipment data.
     *
     * @return \Ignite\Vendor\Helix\Laravel\Carriers\CarrierInterface
     */
    public function carrier()
    {
        if (! trim($this->carrier)) {
            return null;
        }

        try {
            $factory = app(Factory::class);
            return $factory->find($this->order->ship_country, $this->carrier, $this->tracking_number);
        } catch (\Exception $e) {
            return null;
        }
    }
}
