@component('mail::message')

Dear {{ $order->ship_name }},

Thank you! Your order has been shipped.

@if ($carrier)
**Carrier:** {{ $carrier->getName() }}<br />
@if ($carrier->hasTrackingUrl())
<a href="{{ $carrier->getTrackingUrl() }}">Track Package</a><br />
@endif
<br />
@if ($carrier->hasUrl() && $carrier->getTrackingNumber())
Link not working? Go to the <a href="{{ $carrier->getUrl() }}">{{ $carrier->getName() }} Tracking page</a>
and enter your tracking number: **{{ $carrier->getTrackingNumber() }}** .
@endif
@endif

@component('mail::panel')

# Shipping Information

@component('mail::table')
@if ($carrier)
**Shipping Carrier**: {{ $carrier->getCode() }}<br />
**Tracking Number**: {{ $carrier->getTrackingNumber() }}<br />
@endif
**Address**:<br />
{{ html_entity_decode($order->ship_name) }}<br />
{{ $order->ship_address_1 }}<br />
@if ($order->ship_address_3){{ $order->ship_address_2 }}<br />@endif
@if ($order->ship_address_3)**Address 3**: {{ $order->ship_address_3 }}<br />@endif
{{ $order->ship_city }}, {{ $order->ship_state }} {{ $order->ship_postal }}<br />
{{ $order->ship_country }}<br />
@endcomponent
@endcomponent

@component('mail::panel')

# Order Information

**Order number:** {{ $order->number }}
<br />
**Order Date:** {{ $order->created_at->format('F d, Y') }}
@component('mail::table')
| Item              | Quantity              | Points              | Total               |
|:----------------- | ---------------------:| -------------------:| -------------------:|
@foreach ($order->items as $item)
| {{ $item->name }} | {{ $item->quantity }} | {{ Format::amount($item->points) }} | {{ Format::amount($item->quantity * $item->points) }} |
@endforeach
| **Order Total** | &nbsp; | &nbsp; | **{{ Format::amount($order->points) }}** |
@endcomponent

@endcomponent

@component('mail::button', ['url' => $orderUrl])
View my Order
@endcomponent

Thanks,<br />
Reward Headquarters<br /><br />
<small>{{ config('app.name') }}</small>
@endcomponent