<?php

namespace Ignite\HelixCatalog\Providers;

use Illuminate\Support\ServiceProvider;

class HelixCatalogServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->registerFactories();
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
        $this->app->register(EventServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../../config/config.php' => config_path('helix-catalog.php'),
        ], 'config');
        $this->mergeConfigFrom(
            __DIR__.'/../../config/config.php',
            'helix-catalog'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        // Package-provided view source path.
        $sourcePath = __DIR__ . '/../../resources/views';
        // Destination for published package views via vendor:publish.
        $viewPath = resource_path('views/modules/helix-catalog');

        // Allow publishing package views into the host app.
        $this->publishes([
            $sourcePath => $viewPath
        ], 'views');

        // Candidate view lookup paths: app overrides plus package defaults.
        $paths = array_merge(
            array_map(
                function ($path) {
                    return $path . '/modules/helix-catalog';
                },
                config('view.paths')
            ),
            [$sourcePath]
        );

        // Register only existing view directories for the "helix" namespace.
        $this->loadViewsFrom(
            array_filter($paths, 'is_dir'),
            'helix'
        );
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/helix-catalog');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'helix-catalog');
        } else {
            $this->loadTranslationsFrom(__DIR__ .'/../../resources/lang', 'helix-catalog');
        }
    }

    /**
     * Register an additional directory of factories.
     *
     * @return void
     */
    public function registerFactories()
    {
        if (! app()->environment('production') && $this->app->runningInConsole()) {
            $this->loadFactoriesFrom(module_path('HelixCatalog', 'database/factories'));
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
