<?php

namespace Ignite\HelixCatalog\Listeners;

use Illuminate\Auth\Events\Registered;

class SyncOnRegister extends Sync
{
    /**
     * Handle the event.
     *
     * @param Registered $event
     *
     * @return void
     */
    public function handle(Registered $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        $this->session->handle($this->request, $this->user($event->user));
    }
}
