<?php

use Ignite\Catalog\Entities\OrderItem;
use Ignite\Vendor\Helix\Laravel\Resources\Order as HelixOrder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class HelixAddCategoryToOrderItem extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('catalog_order_item', 'category')) {
            Schema::table('catalog_order_item', function (Blueprint $table) {
                $table->string('category')->after('class')->nullable();
            });
        }

        $this->migrateItemCategory();
    }

    /**
     * Reverse the migrations.
     *
     * -------------------------------------------------- //
     * Be Careful!
     * -------------------------------------------------- //
     * This may drop data in the category column if it
     * pre-existed before the migration!
     * --------------------------------------------------
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('catalog_order_item', 'category')) {
            Schema::table('catalog_order_item', function (Blueprint $table) {
                $table->dropColumn('category');
            });
        }
    }

    /**
     * Migrate item category.
     *
     * @return void
     */
    protected function migrateItemCategory(): void
    {
        $orderItems = OrderItem::query()->whereNull('category')->get();
        foreach ($orderItems as $orderItem) {
            if (empty($orderItem->vendor_meta['number'])) {
                continue;
            }

            $helixItem = HelixOrder::where('order_number', $orderItem->vendor_meta['number'])->first();
            foreach ($helixItem->products as $product) {
                if ($product['id'] == $orderItem->sku) {
                    $orderItem->update(['category' => $product['categoryName']]);
                }
            }
        }
    }
}
