<?php

namespace Ignite\HelixCatalog\Database\Seeders;

use Ignite\Catalog\Entities\Catalog;
use Ignite\Catalog\Entities\Vendor;
use Illuminate\Database\Seeder;

class CatalogVendorTableSeeder extends Seeder
{
    public function run()
    {
        $vendor = Vendor::query()->updateOrCreate(["name" => "helix-iframe"], [
            "name" => "helix-iframe",
            "type" => "merchandise",
            "image_path" => 'catalog/merchandise',
            "vendor_countries" => 'US,CA',
            "redemption_class" => \Ignite\Catalog\Vendors\NullProcessor::class,
            "active" => 1
        ]);

        Catalog::query()->updateOrCreate(["code" => "helix-catalog"], [
            "catalog_vendor_id" => $vendor->getKey(),
            "code" => "helix-catalog",
            "name" => "Merchandise",
            "type" => "merchandise",
            "countries" => 'US,CA',
            "description" => "International Merchandise Catalog.",
            "active" => 1
        ]);
    }
}
