<?php

namespace Ignite\HelixCatalog\Providers;

use Ignite\Core\Events\ImpersonationStarted;
use Ignite\Core\Events\ImpersonationStopped;
use Ignite\HelixCatalog\Listeners\ImpersonateHelixUser;
use Ignite\HelixCatalog\Listeners\ImpersonateHelixUserStopped;
use Ignite\HelixCatalog\Listeners\StoreOrderDetails;
use Ignite\HelixCatalog\Listeners\UpdateShippingOrderStatus;
use Ignite\Vendor\Helix\Laravel\Events\OrderResourceCreated;
use Ignite\Vendor\Helix\Laravel\Events\WebhookResourceCreated;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        OrderResourceCreated::class => [
            StoreOrderDetails::class
        ],
        WebhookResourceCreated::class => [
            UpdateShippingOrderStatus::class
        ],
        ImpersonationStarted::class => [
            ImpersonateHelixUser::class,
        ],
        ImpersonationStopped::class => [
            ImpersonateHelixUserStopped::class,
        ]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
