<?php

namespace Ignite\HelixCatalog\Entities;

use Ignite\Core\Entities\User as IgniteUser;
use Ignite\HelixCatalog\Contracts\PayloadTransformerInterface;
use Ignite\HelixCatalog\Transformers\PayloadTransformer;
use Ignite\Vendor\Helix\Laravel\Contracts\ProvidesHelixPayload;
use Ignite\Vendor\Helix\Laravel\Resources\Concerns\Payloadable;

class User extends IgniteUser implements ProvidesHelixPayload
{
    use Payloadable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [];

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Indicates if all mass assignment is enabled.
     *
     * @var bool
     */
    protected static $unguarded = true;

    /**
     * Provide the helix payload data necessary to authenticate a user.
     *
     * @return array
     */
    public function toPayload()
    {
        return $this->getPayloadTransformer()->transform($this);
    }

    /**
     * The transformer class to turn an Ignite User record into a Helix User payload.
     *
     * @return PayloadTransformerInterface
     */
    public function getPayloadTransformer()
    {
        return app(config('helix-catalog.payload.transformer', PayloadTransformer::class));
    }

    /**
     * The total points the participant has earned.
     *
     * @return int
     */
    public function getPointsAttribute()
    {
        if (! $this->participant) {
            return 0;
        }

        return $this->participant->transactions()->sum('value');
    }
}
