<?php

namespace Ignite\HelixCatalog\Emails;

use Ignite\HelixCatalog\Entities\Shipment;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Ignite\Catalog\Entities\Order;
use Ignite\Core\Entities\User;

class OrderShipped extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * @var Order
     */
    protected $order;

    /**
     * @var Shipment
     */
    protected $shipment;

    /**
     * Create a new order submitted message instance.
     *
     * @param Order $order
     * @param Shipment $shipment
     * @param string $locale
     */
    public function __construct($order, $shipment)
    {
        $this->order = $order;
        $this->shipment = $shipment;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if (! $this->order->relationLoaded('items')) {
            $this->order->load('items');
        }

        if (! $this->order->relationLoaded('participant')) {
            $this->order->load('participant');
        }

        $appName = config('app.name');

        // $this->to($this->order->participant->email, $this->order->participant->fullName());
        $this->subject("{$appName} - Order #{$this->order->number} has shipped!");
        $this->from(config('mail.from.address'), config('mail.from.name'));
        $this->bcc(config('mail.from.address'), config('mail.from.name'));

        return $this->markdown('helix::emails.orders.shipped', [
            'first_name' => $this->order->participant->first,
            'last_name' => $this->order->participant->last,
            'email' => $this->order->participant->email,
            'order' => $this->order,
            'orderUrl' => $this->getOrderUrl(),
            'carrier' => $this->shipment->carrier()
        ]);
    }

    /**
     * The tracked URL for the order detail page.
     *
     * @return string
     */
    protected function getOrderUrl()
    {
        return route('catalog.order.show', [
            'number' => $this->order->number,
            'utm_source' => 'notification',
            'utm_medium' => 'email',
            'utm_campaign' => 'order_submitted'
        ]);
    }
}
