<?php

namespace Ignite\HelixCatalog\Listeners;

use Illuminate\Auth\Events\Login;

class SyncOnLogin extends Sync
{
    /**
     * Handle the event.
     *
     * @param Login $event
     *
     * @return void
     * @see \Ignite\Vendor\Helix\Laravel\Listeners\SyncOnLogin
     */
    public function handle(Login $event)
    {
        if (!config('helix.enabled')) {
            return;
        }

        $this->session->handle($this->request, $this->user($event->user));
    }
}

