<?php

namespace Ignite\HelixCatalog\Database\Seeders;

use Ignite\Catalog\Entities\Catalog;
use Ignite\Catalog\Entities\Vendor;
use Illuminate\Database\Seeder;

class CatalogVendorTableSeeder extends Seeder
{
    public function run()
    {
        $vendor = Vendor::query()->updateOrCreate(["name" => "helix-iframe"], [
            "name" => "helix-iframe",
            "type" => "merchandise",
            "image_path" => '',
            "vendor_countries" => '',
            "redemption_class" => \Ignite\Catalog\Vendors\NullProcessor::class,
            "active" => 1
        ]);

        Catalog::query()->updateOrCreate(["code" => "helix-iframe-catalog"], [
            "catalog_vendor_id" => $vendor->getKey(),
            "code" => "helix-iframe-catalog",
            "name" => "Helix iFrame Catalog",
            "type" => "merchandise",
            "countries" => '',
            "description" => "International Merchandise Catalog.",
            "active" => 1
        ]);
    }
}
