<?php

namespace Ignite\HelixCatalog\Listeners;

use Ignite\Core\Events\ImpersonationStopped;

class ImpersonateHelixUserStopped extends Sync
{
    /**
     * Handle the event.
     *
     * @param ImpersonationStopped $event
     *
     * @return void
     * @see \Ignite\Vendor\Helix\Laravel\Listeners\SyncOnLogin
     */
    public function handle(ImpersonationStopped $event)
    {
        if (! config('helix.enabled')) {
            return;
        }

        $this->session->handle($this->request, $this->user($event->impersonator));
    }
}
