<?php

namespace Ignite\Vendor\Helix\Tests\Models\Request;

use Ignite\Vendor\Helix\Models\Request\OrderItem;
use Ignite\Vendor\Helix\Tests\TestCase;

class OrderItemTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_cast_to_an_array()
    {
        $orderItem = new OrderItem($data = [
            'product_id' => 12345,
            'qty' => 2,
        ]);

        $this->assertEquals($data, $orderItem->toArray());
    }

    /**
     * @test
     */
    public function it_can_cast_to_json()
    {
        $orderItem = new OrderItem($data = [
            'product_id' => 12345,
            'qty' => 2,
        ]);

        $this->assertEquals(json_encode($data), $orderItem->toJson());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_product_id()
    {
        $orderItem = new OrderItem([
            'product_id' => 12345
        ]);

        $this->assertEquals(12345, $orderItem->getProductId());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_qty()
    {
        $orderItem = new OrderItem([
            'qty' => '2'
        ]);

        $this->assertEquals(2, $orderItem->getQty());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_physical_ecertificate_type()
    {
        $orderItem = new OrderItem([
            'ecertificate' => OrderItem::CARD_TYPE_PHYSICAL
        ]);

        $this->assertEquals(0, $orderItem->getEcertificate());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_electronic_ecertificate_type()
    {
        $orderItem = new OrderItem([
            'ecertificate' => OrderItem::CARD_TYPE_ECERTIFICATE
        ]);

        $this->assertEquals(1, $orderItem->getEcertificate());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_both_ecertificate_types()
    {
        $orderItem = new OrderItem([
            'ecertificate' => OrderItem::CARD_TYPE_BOTH
        ]);

        $this->assertEquals(2, $orderItem->getEcertificate());
    }
}
