<?php

namespace Ignite\Vendor\Helix;

use Ignite\Vendor\Helix\Models\Request\BillingCollection;
use Ignite\Vendor\Helix\Models\Request\OrderCollection;
use Psr\Http\Message\ResponseInterface;

/**
 * Interface DecoratorInterface
 *
 * @method mixed getBrandList()
 * @method mixed getCategoryList($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getSubCategoryList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductDetails($productId, $lang = 'eng', $countryCode = 'US')
 * @method mixed getOrderDetails($orderId)
 * @method mixed placeOrder(array $billingItems, array $orderItems)
 * @method mixed cancelOrder($orderId)
 */
interface DecoratorInterface extends HelixInterface
{
    /**
     * Decorate the client response.
     *
     * @param  ResponseInterface $response
     * @return mixed
     */
    public function decorate(ResponseInterface $response);
}
