<?php

namespace Ignite\Vendor\Helix\Tests\Decorators;

use Ignite\Vendor\Helix\ClientInterface;
use Ignite\Vendor\Helix\Tests\TestCase;
use Ignite\Vendor\Helix\Decorators\Json;
use Mockery;
use Psr\Http\Message\ResponseInterface;

class JsonTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_proxy_requests_through_the_client_and_parse_the_json()
    {
        $response = Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')->andReturn('{"status": "success"}');
        $client = Mockery::mock(ClientInterface::class);
        $client->shouldReceive('getBrandList')->andReturn($response);

        $decorator = new Json($client);
        $response = $decorator->getBrandList();

        $this->assertIsArray($response);
        $this->assertArrayHasKey('status', $response);
    }

    /**
     * @test
     */
    public function it_will_fail_to_proxy_requests_through_the_client_when_the_method_doesnt_exist()
    {
        $this->expectException(\Exception::class);
        $this->expectExceptionMessageRegExp('/^Unknown method foo/');

        $client = Mockery::mock(ClientInterface::class);

        $decorator = new Json($client);
        $decorator->foo();
    }
}
