<?php

namespace Ignite\Vendor\Helix\Tests\Transformers;

use Mockery;
use Ignite\Vendor\Helix\Tests\TestCase;
use Ignite\Vendor\Helix\Transformers\Json;
use Psr\Http\Message\ResponseInterface;

class JsonTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_transform_a_string_of_json_as_an_associative_array()
    {
        $response = Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')->andReturn('{"status": "success"}');

        $transformer = new Json();
        $data = $transformer->transform($response);
        $this->assertIsArray($data);
        $this->assertArrayHasKey('status', $data);
    }

    /**
     * @test
     */
    public function it_can_transform_a_string_of_json_as_an_stdclass()
    {
        $response = Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')->andReturn('{"status": "success"}');

        $transformer = new Json();
        $data = $transformer->objects()->transform($response);
        $this->assertInstanceOf(\stdClass::class, $data);
        $this->assertEquals('success', $data->status);
    }

    /**
     * @test
     */
    public function it_will_return_an_empty_array_when_response_body_is_empty()
    {
        $response = Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')->andReturn('');

        $transformer = new Json();
        $data = $transformer->transform($response);
        $this->assertIsArray($data);
        $this->assertEmpty($data);
    }

    /**
     * @test
     */
    public function it_will_return_an_empty_stdclass_when_response_body_is_empty()
    {
        $response = Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')->andReturn('');

        $transformer = new Json();
        $data = $transformer->objects()->transform($response);
        $this->assertInstanceOf(\stdClass::class, $data);
        $this->assertEmpty(get_object_vars($data));
    }

    /**
     * @test
     */
    public function it_will_throw_an_exception_when_it_cannot_parse_the_given_string_as_json()
    {
        $response = Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')->andReturn('{foo: bar');

        $this->expectException(\Exception::class);
        $this->expectExceptionMessageRegExp('/^Error decoding JSON/');

        $transformer = new Json();
        $transformer->objects()->transform($response);
    }
}
