<?php

namespace Ignite\Vendor\Helix\Tests\Models\Request;

use Ignite\Vendor\Helix\Models\Request\User;
use Ignite\Vendor\Helix\Tests\TestCase;

class UserTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_cast_to_an_array()
    {
        $user = new User($data = $this->getData([
            'helixUserId' => 123456
        ]));

        $this->assertEquals($data, $user->toArray());
    }

    /**
     * @test
     */
    public function it_can_cast_to_json()
    {
        $user = new User($data = $this->getData([
            'helixUserId' => 123456
        ]));

        $this->assertEquals(json_encode($data, JSON_NUMERIC_CHECK), $user->toJson());
    }

    /**
     * @test
     */
     public function it_can_get_the_catalog_id()
     {
         $user = new User($data = $this->getData(['catalogId' => 'ABC123']));

         $this->assertEquals('ABC123', $user->getCatalogId());
     }

    /**
     * @test
     */
    public function it_can_get_the_access_token()
    {
        $user = new User($data = $this->getData(['accessToken' => 'ABC123']));

        $this->assertEquals('ABC123', $user->getAccessToken());
    }

    /**
     * @test
     */
    public function it_can_get_the_client_user_id()
    {
        $user = new User($data = $this->getData(['clientUserId' => '12345']));

        $this->assertEquals('12345', $user->getClientUserId());
    }

    /**
     * @test
     */
    public function it_can_get_the_first_name()
    {
        $user = new User($data = $this->getData(['firstName' => 'Toby']));

        $this->assertEquals('Toby', $user->getFirstName());
    }

    /**
     * @test
     */
    public function it_can_get_the_last_name()
    {
        $user = new User($data = $this->getData(['lastName' => 'Flenderson']));

        $this->assertEquals('Flenderson', $user->getLastName());
    }

    /**
     * @test
     */
    public function it_can_get_the_primary_language()
    {
        $user = new User($data = $this->getData(['PrimaryLanguage' => 'en']));

        $this->assertEquals('en', $user->getPrimaryLanguage());
    }

    /**
     * @test
     */
    public function it_can_get_the_points()
    {
        $user = new User($data = $this->getData(['points' => '50']));

        $this->assertEquals('50', $user->getPoints());
    }

    /**
     * Get the data and pass in any overrides.
     *
     * @param  array $overrides
     * @return array
     */
    private function getData($overrides = [])
    {
        return array_merge($this->getRequiredData(), $overrides);
    }

    /**
     * The required data for a basic user model.
     *
     * @return array
     */
    private function getRequiredData()
    {
        return [
            'catalogId' => '12345TFDM',
            'accessToken' => '12345TFDM',
            'clientUserId' => '12345TFDM',
            'firstName' => 'Toby',
            'lastName' => 'Flenderson',
            'PrimaryLanguage' => 'en',
            'points' => 50,
            'homeCountry' => 'US',
            'shipAddress1' => '102 Decker Ct',
            'shipCity' => 'Irving',
            'shipState' => 'TX',
            'shipPostalCode' => 75062,
            'shipCountry' => 'US',
            'phoneNumber1' => '5551234567',
            'emailAddress' => 'toby.flenderson@brightspot.email',
            'primaryLanguage' => 'en'
        ];
    }
}
