<?php

namespace Ignite\Vendor\Helix\Models\Request;

use Ignite\Vendor\Helix\Models\Model;

/**
 * Class User
 *
 * @method string getCatalogId()
 * @method string getAccessToken()
 * @method string getHelixUserId()
 * @method string getClientUserId()
 * @method string getFirstName()
 * @method string getLastName()
 * @method string getPrimaryLanguage()
 * @method string getPoints()
 * @method string getHomeAddress1()
 * @method string getHomeAddress2
 * @method string getHomeCity()
 * @method string getHomeState()
 * @method string getHomePostalCode()
 * @method string getHomeCountry()
 * @method string getShipAddress1()
 * @method string getShipAddress2()
 * @method string getShipCity()
 * @method string getShipState()
 * @method string getShipPostalCode()
 * @method string getShipCountry()
 * @method string getPhoneNumber1()
 * @method string getPhoneNumber2()
 * @method string getEmailAddress()
 * @method string getCustomField1()
 * @method string getCustomField2()
 * @method string getCustomField3()
 * @method string getYos()
 */
class User extends Model
{
    /**
     * @var array
     */
    protected $allowedKeys = [
        'helixUserId',
        'catalogId',
        'accessToken',
        'clientUserId',
        'firstName',
        'lastName',
        'primaryLanguage',
        'points',
        'phoneNumber1',
        'phoneNumber2',
        'emailAddress',
        'shipAddress1',
        'shipAddress2',
        'shipCity',
        'shipState',
        'shipPostalCode',
        'shipCountry',
        'homeAddress1',
        'homeAddress2',
        'homeCity',
        'homeState',
        'homePostalCode',
        'homeCountry',
        'customField1',
        'customField2',
        'customField3',
    ];

    /**
     * The required properties.
     *
     * @var array
     */
    protected $requiredKeys = [
        'helixUserId',
        'catalogId',
        'accessToken',
        'clientUserId',
        'firstName',
        'lastName',
        'phoneNumber1',
        'emailAddress',
        'primaryLanguage',
        'points',
        'shipAddress1',
        'shipCity',
        'shipState',
        'shipPostalCode',
        'shipCountry',
    ];

    /**
     * Cast the object to an array.
     *
     * @return array
     */
    public function toArray()
    {
        foreach ($this->requiredKeys as $property) {
            $this->guardAgainstMissingData($property);
        }

        return array_filter(parent::toArray(), function ($key) {
            return ! array_key_exists($key, $this->allowedKeys);
        }, ARRAY_FILTER_USE_KEY);
    }

    /**
     * The payload for sign up.
     *
     * @return array
     */
    public function forSignUp()
    {
        $except = ['helixUserId' => null];

        return array_diff($this->toArray(), $except);
    }

    /**
     * The payload for sign in.
     *
     * @return array
     */
    public function forSignIn()
    {
        $this->requiredKeys[] = 'helixUserId';

        return $this->toArray();
    }

    /**
     * Ensure the model has a property before being used with a collaborator.
     *
     * @param  string $property
     * @throws \RuntimeException
     */
    private function guardAgainstMissingData($property)
    {
        if (! isset($this->data[$property]) || empty(trim($this->data[$property]))) {
            throw new \RuntimeException(
                "User payload is missing required `{$property}` property value."
            );
        }
    }
}
