<?php

namespace Ignite\Vendor\Helix\Models\Request;

use Ignite\Vendor\Helix\Models\Model;
use RuntimeException;

/**
 * Class BillingItem
 *
 * @method string getFirstName()
 * @method string getLastName()
 * @method string getEmailId()
 * @method string getCompanyName()
 * @method string getAddress1()
 * @method string getAddress2()
 * @method string getPostalCode()
 * @method string getCity()
 * @method string getState()
 * @method string getCountryId()
 * @method string getIpAddress()
 */
class BillingItem extends Model
{
    /**
     * The required properties.
     *
     * @var array
     */
    private $required = [
        'first_name',
        'last_name',
        'email_id',
        'company_name',
        'address1',
        'address2',
        'postal_code',
        'city',
        'state',
        'countryCode',
        'ip_address'
    ];

    /**
     * Set the special casing for countryCode.
     *
     * @param  string $value
     * @return self
     */
    public function setCountryCode($value)
    {
        return $this->set('countryCode', $value);
    }

    /**
     * Get the special casing for countryCode.
     *
     * @param  string $default
     * @return self
     */
    public function getCountryCode($default = null)
    {
        return $this->get('countryCode', $default);
    }

    /**
     * Set the IP Address only after validating.
     *
     * @param  string $value
     * @return mixed
     */
    public function setIpAddress($value)
    {
        if (! filter_var($value, FILTER_VALIDATE_IP)) {
            throw new \InvalidArgumentException("The IP Address is invalid: $value");
        }

        return $this->set('ip_address', $value);
    }

    /**
     * Cast the object to an array.
     *
     * @return array
     */
    public function toArray()
    {
        foreach ($this->required as $property) {
            $this->guardAgainstMissingData($property);
        }

        return parent::toArray();
    }

    /**
     * Ensure the model has a property before being used with a collaborator.
     *
     * @param  string $property
     * @throws RuntimeException
     */
    private function guardAgainstMissingData($property)
    {
        if (! isset($this->data[$property]) || empty(trim($this->data[$property]))) {
            throw new RuntimeException(
                "BillingItem class is missing required `{$property}` property value."
            );
        }
    }
}
