<?php

namespace Ignite\Vendor\Helix\Tests;

use Ignite\Vendor\Helix\Authentication;

class AuthenticationTest extends TestCase
{
    /**
     * @test
     */
    public function it_allows_public_access_to_the_username()
    {
        $auth = new Authentication($this->username, $this->password, $this->endpoint);
        $this->assertEquals($this->username, $auth->username());
    }

    /**
     * @test
     */
    public function it_allows_public_access_to_the_password()
    {
        $auth = new Authentication($this->username, $this->password, $this->endpoint);
        $this->assertEquals($this->password, $auth->password());
    }

    /**
     * @test
     */
    public function it_allows_public_access_to_the_endpoint()
    {
        $auth = new Authentication($this->username, $this->password, $this->endpoint);
        $this->assertEquals($this->endpoint, $auth->endpoint());
    }

    /**
     * @test
     */
    public function it_can_create_a_bearer_token()
    {
        $auth = new Authentication($this->username, $this->password, $this->endpoint);
        $this->assertEquals(base64_encode($this->username . ':' . $this->password), $auth->token());
    }
}
