<?php

namespace Ignite\Vendor\Helix\Transformers;

use Exception;
use Ignite\Vendor\Helix\TransformerInterface;
use Psr\Http\Message\ResponseInterface;
use stdClass;

final class Json implements TransformerInterface
{
    /**
     * Flag to determine whether to return an associative array or a stdClass.
     *
     * @var bool
     */
    private $associative = true;

    /**
     * Decode the json as a \stdClass object.
     *
     * @return self
     */
    public function objects()
    {
        $this->associative = false;

        return $this;
    }

    /**
     * Decode the json as an associative array.
     *
     * @return self
     */
    public function associative()
    {
        $this->associative = true;

        return $this;
    }

    /**
     * Transform the response data from JSON.
     *
     * @param  ResponseInterface $response
     * @return array|mixed
     * @throws Exception
     */
    public function transform(ResponseInterface $response)
    {
        $contents = strval($response->getBody());

        if (empty($contents)) {
            return $this->associative ? [] : new stdClass;
        }

        $data = json_decode($contents, $this->associative);

        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception('Error decoding JSON: ' . json_last_error_msg() . ". Body: $contents" );
        }

        return $data;
    }
}
