<?php

namespace Ignite\Vendor\Helix\Models\Request;

use Ignite\Vendor\Helix\Models\Collection;
use Ignite\Vendor\Helix\Models\Model;

class OrderCollection extends Collection
{
    /**
     * Add many items via an array.
     *
     * @param array $items
     */
    protected function addMany(array $items = [])
    {
        foreach ($items as $item) {
            $this->addItem($item);
        }
    }

    /**
     * Add a OrderItem to the collection.
     *
     * @param  OrderItem $orderItem
     * @return OrderCollection
     */
    public function addItem(OrderItem $orderItem)
    {
        return $this->add($orderItem, $orderItem->getProductId());
    }

    /**
     * Get a OrderItem from the collection.
     *
     * @param  string|int $productId
     * @return Model|OrderItem
     */
    public function getItem($productId)
    {
        return $this->get($productId);
    }

    /**
     * Remove a OrderItem from the collection.
     *
     * @param  string|int $productId
     * @return OrderCollection
     */
    public function removeItem($productId)
    {
        return $this->remove($productId);
    }
}
