<?php

namespace Ignite\Vendor\Helix\Decorators;

use Ignite\Vendor\Helix\AbstractDecorator;
use Ignite\Vendor\Helix\Transformers\Json as JsonTransformer;
use Psr\Http\Message\ResponseInterface;

/**
 * Json Response Decorator.
 *
 * @method mixed getBrandList()
 * @method mixed getCategoryList($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getSubCategoryList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductList($categoryId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getProductDetails($productId, $countryCode = 'US', $languageCode = 'eng')
 * @method mixed getFeaturedProducts($countryCode = 'US', $languageCode = 'eng')
 * @method mixed getOrderDetails($orderId)
 * @method mixed placeOrder(array $billingItems, array $orderItems)
 * @method mixed cancelOrder($orderId)
 */
final class Json extends AbstractDecorator
{
    /**
     * Decorate the client response.
     *
     * @param  ResponseInterface $response
     * @return array|mixed
     * @throws \Exception
     */
    public function decorate(ResponseInterface $response)
    {
        return (new JsonTransformer)->transform($response);
    }
}
