<?php

namespace Ignite\Vendor\Helix\Values;

final class OrderId extends Value
{
    /**
     * Set the OrderId value.
     *
     * @param mixed $value
     */
    protected function setValue($value)
    {
        $value = (int) $value;

        if ($value <= 0) {
            throw new \OutOfBoundsException('Order Id cannot be less than or equal to zero.');
        }

        if ($value >= PHP_INT_MAX) {
            throw new \OutOfBoundsException('Order Id cannot greater than or equal to PHP_INT_MAX.');
        }

        $this->value = $value;
    }
}
