<?php

namespace Ignite\Vendor\Helix\Models\Request;

use Ignite\Vendor\Helix\Models\Model;

/**
 * Class OrderItem
 *
 * @method string getProductId()
 * @method string getEcertificate()
 * @method string getEcertType()
 */
class OrderItem extends Model
{
    const CARD_TYPE_PHYSICAL = 0;
    const CARD_TYPE_ECERTIFICATE = 1;
    const CARD_TYPE_BOTH = 2;

    /**
     * The required properties.
     *
     * @var array
     */
    private $required = [
        'product_id',
        'qty'
    ];

    /**
     * The quantity to order.
     *
     * @return int
     */
    public function getQty()
    {
        return (int) $this->get('qty');
    }

    /**
     * Cast the object to an array.
     *
     * @return array
     */
    public function toArray()
    {
        foreach ($this->required as $property) {
            $this->guardAgainstMissingData($property);
        }

        return parent::toArray();
    }

    /**
     * Ensure the model has a property before being used with a collaborator.
     *
     * @param  string $property
     * @throws \RuntimeException
     */
    private function guardAgainstMissingData($property)
    {
        if (! isset($this->data[$property]) || empty(trim($this->data[$property]))) {
            throw new \RuntimeException(
                "OrderItem class is missing required `{$property}` property value."
            );
        }
    }
}
