<?php

namespace Ignite\Vendor\Helix\Models\Request;

use Ignite\Vendor\Helix\Models\Collection;
use Ignite\Vendor\Helix\Models\Model;

class BillingCollection extends Collection
{
    /**
     * Add many items via an array.
     *
     * @param array $items
     */
    protected function addMany(array $items = [])
    {
        foreach ($items as $item) {
            $this->addItem($item);
        }
    }

    /**
     * Add a BillingItem to the collection.
     *
     * @param  BillingItem $billingItem
     * @return BillingCollection
     */
    public function addItem(BillingItem $billingItem)
    {
        return $this->add($billingItem, $billingItem->getEmailId());
    }

    /**
     * Get a BillingItem from the collection.
     *
     * @param  string|int $emailId
     * @return Model|BillingItem
     */
    public function getItem($emailId)
    {
        return $this->get($emailId);
    }

    /**
     * Remove a BillingItem from the collection.
     *
     * @param  string|int $emailId
     * @return BillingCollection
     */
    public function removeItem($emailId)
    {
        return $this->remove($emailId);
    }
}
