<?php

namespace Ignite\Vendor\Helix\Tests\Models\Request;

use Ignite\Vendor\Helix\Models\Model;
use Ignite\Vendor\Helix\Models\Request\OrderCollection;
use Ignite\Vendor\Helix\Models\Request\OrderItem;
use Ignite\Vendor\Helix\Tests\TestCase;
use Mockery;

class OrderCollectionTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_add_a_order_item_to_the_collection()
    {
        $collection = new OrderCollection();

        $collection->addItem(new OrderItem([]));

        $this->assertCount(1, $collection);
    }

    /**
     * @test
     */
    public function it_can_only_add_a_order_item_to_the_collection()
    {
        $collection = new OrderCollection();

        $this->expectException(\TypeError::class);

        $collection->addItem(Mockery::mock(Model::class));
    }

    /**
     * @test
     */
    public function it_can_get_a_order_item_in_the_collection()
    {
        $collection = new OrderCollection();
        $item = new OrderItem(['product_id' => 12345]);

        $collection->addItem($item);

        $this->assertSame($item, $collection->getItem(12345));
    }

    /**
     * @test
     */
    public function it_can_remove_a_Order_item_from_the_collection_by_email()
    {
        $collection = new OrderCollection([
            new OrderItem(['product_id' => 12345])
        ]);

        $this->assertCount(1, $collection);

        $collection->removeItem(12345);

        $this->assertCount(0, $collection);
    }

    /**
     * @test
     */
    public function it_can_cast_the_collection_to_an_array_and_cascade_all_items()
    {
        $collection = new OrderCollection([
            new OrderItem($data1 = $this->getOrderData(['product_id' => 12345])),
            new OrderItem($data2 = $this->getOrderData(['product_id' => 67890]))
        ]);

        $this->assertEquals([$data1, $data2], $collection->toArray());
    }

    /**
     * @test
     */
    public function it_can_cast_the_collection_to_an_json_and_cascade_all_items()
    {
        $collection = new OrderCollection([
            new OrderItem($data1 = $this->getOrderData(['product_id' => 12345])),
            new OrderItem($data2 = $this->getOrderData(['product_id' => 67890]))
        ]);

        $this->assertEquals(
            json_encode([$data1, $data2], JSON_NUMERIC_CHECK),
            $collection->toJson()
        );
    }
}
