<?php

namespace Ignite\Vendor\Helix\Tests\Models\Request;

use Ignite\Vendor\Helix\Models\Model;
use Ignite\Vendor\Helix\Models\Request\BillingCollection;
use Ignite\Vendor\Helix\Models\Request\BillingItem;
use Ignite\Vendor\Helix\Tests\TestCase;
use Mockery;

class BillingCollectionTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_add_a_billing_item_to_the_collection()
    {
        $collection = new BillingCollection();

        $collection->addItem(new BillingItem([]));

        $this->assertCount(1, $collection);
    }

    /**
     * @test
     */
    public function it_can_only_add_a_billing_item_to_the_collection()
    {
        $collection = new BillingCollection();

        $this->expectException(\TypeError::class);

        $collection->addItem(Mockery::mock(Model::class));
    }

    /**
     * @test
     */
    public function it_can_get_a_billing_item_in_the_collection()
    {
        $collection = new BillingCollection();
        $item = new BillingItem(['email_id' => 'foo@test.com']);

        $collection->addItem($item);

        $this->assertSame($item, $collection->getItem('foo@test.com'));
    }

    /**
     * @test
     */
    public function it_can_remove_a_billing_item_from_the_collection_by_email()
    {
        $collection = new BillingCollection([
            new BillingItem(['email_id' => 'foo@test.com'])
        ]);

        $this->assertCount(1, $collection);

        $collection->removeItem('foo@test.com');

        $this->assertCount(0, $collection);
    }

    /**
     * @test
     */
    public function it_can_cast_the_collection_to_an_array_and_cascade_all_items()
    {
        $collection = new BillingCollection([
            new BillingItem($data1 = $this->getBillingData(['email_id' => 'foo@test.com'])),
            new BillingItem($data2 = $this->getBillingData(['email_id' => 'bar@test.com']))
        ]);

        $this->assertEquals([$data1, $data2], $collection->toArray());
    }

    /**
     * @test
     */
    public function it_can_cast_the_collection_to_an_json_and_cascade_all_items()
    {
        $collection = new BillingCollection([
            new BillingItem($data1 = $this->getBillingData(['email_id' => 'foo@test.com'])),
            new BillingItem($data2 = $this->getBillingData(['email_id' => 'bar@test.com']))
        ]);

        $this->assertEquals(
            json_encode([$data1, $data2], JSON_NUMERIC_CHECK),
            $collection->toJson()
        );
    }
}
