<?php

namespace Ignite\Vendor\Helix;

use Ignite\Vendor\Helix\Models\Request\BillingCollection;
use Ignite\Vendor\Helix\Models\Request\OrderCollection;

interface ClientInterface extends HelixInterface
{
    /**
     * The list of brands.
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getBrandList();

    /**
     * The list of categories.
     *
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getCategoryList($countryCode = 'US', $languageCode = 'eng');

    /**
     * The list of sub-categories.
     *
     * @param  int $categoryId
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getSubCategoryList($categoryId, $countryCode = 'US', $languageCode = 'eng');

    /**
     * The list of products within a given category.
     *
     * @param  int $categoryId
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getProductList($categoryId, $countryCode = 'US', $languageCode = 'eng');

    /**
     * The details of the given product.
     *
     * @param  int $productId
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getProductDetails($productId, $countryCode = 'US', $languageCode = 'eng');

    /**
     * The featured products for the site.
     *
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getFeaturedProducts($countryCode = 'US', $languageCode = 'eng');

    /**
     * The special products for the site.
     *
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getSpecialProducts($countryCode = 'US', $languageCode = 'eng');

    /**
     * The new products for the site.
     *
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getNewProducts($countryCode = 'US', $languageCode = 'eng');

    /**
     * The new products for the site.
     *
     * @param  int $productId
     * @param  string $countryCode
     * @param  string $languageCode
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getSimilarProducts($productId, $countryCode = 'US', $languageCode = 'eng');

    /**
     * The details of the given order.
     *
     * @param  int $orderId
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function getOrderDetails($orderId);

    /**
     * Place an order.
     *
     * @param array $billingItems
     * @param array $orderItems
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function placeOrder(array $billingItems, array $orderItems);

    /**
     * Cancel the given order.
     *
     * @param  int $orderId
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function cancelOrder($orderId);
}
