<?php

namespace Ignite\Vendor\Helix\Tests;

use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Psr7\Stream;
use Ignite\Vendor\Helix\Models\Request\BillingItem;
use Ignite\Vendor\Helix\Models\Request\OrderItem;
use Psr\Http\Message\ResponseInterface;

class TestCase extends \PHPUnit\Framework\TestCase
{
    /**
     * The test account username.
     *
     * @var string
     */
    protected $username = 'helix_user';

    /**
     * The test account password.
     *
     * @var string
     */
    protected $password = 'AQw@as124';

    /**
     * The test account endpoint.
     *
     * @var int
     */
    protected $endpoint = 'http://52.60.111.154:3007/api/20/';

    /**
     * Assert the the given response is successful and contains the correct status code and body object.
     *
     * @param ResponseInterface $response
     */
    protected function assertResponseSuccessful(ResponseInterface $response)
    {
        $this->assertInstanceOf(Response::class, $response);
        $this->assertEquals(200, $response->getStatusCode());
        $this->assertInstanceOf(Stream::class, $response->getBody());
    }

    /**
     * An array of a billing item data.
     *
     * @param  array $overrides
     * @return array
     */
    protected function getBillingData(array $overrides = [])
    {
        return array_merge([
            'first_name' => 'John',
            'last_name' => 'Smith',
            'email_id' => 'foo',
            'company_name' => 'Brightspot',
            'address1' => '102 Decker Ct',
            'address2' => 'Suite 150',
            'postal_code' => '75062',
            'city' => 'Irving',
            'state' => 'TX',
            'countryCode' => 'US',
            'ip_address' => '47.190.18.3'
        ], $overrides);
    }

    /**
     * An instance of a billing item class.
     *
     * @param  array $overrides
     * @return BillingItem
     */
    protected function getBillingItem(array $overrides = [])
    {
        return new BillingItem($this->getBillingData($overrides));
    }

    /**
     * An array of a billing item data.
     *
     * @param  array $overrides
     * @return array
     */
    protected function getOrderData(array $overrides = [])
    {
        return array_merge([
            'product_id' => 2995,
            'qty' => 1
        ], $overrides);
    }

    /**
     * An instance of a order item class.
     *
     * @param  array $overrides
     * @return OrderItem
     */
    protected function getOrderItem(array $overrides = [])
    {
        return new OrderItem($this->getOrderData($overrides));
    }
}
