<?php

namespace Ignite\Vendor\Helix\Tests\Models\Request;

use Ignite\Vendor\Helix\Models\Request\BillingItem;
use Ignite\Vendor\Helix\Tests\TestCase;

class BillingItemTest extends TestCase
{
    /**
     * @test
     */
    public function it_can_cast_to_an_array()
    {
        $billingItem = new BillingItem($data = [
            'first_name' => 'John',
            'last_name' => 'Smith',
            'email_id' => 'foo',
            'company_name' => 'Brightspot',
            'address1' => '102 Decker Ct',
            'address2' => 'Suite 150',
            'postal_code' => '75062',
            'city' => 'Irving',
            'state' => 'TX',
            'countryCode' => 'US',
            'ip_address' => '47.190.18.3'
        ]);

        $this->assertEquals($data, $billingItem->toArray());
    }

    /**
     * @test
     */
    public function it_can_cast_to_json()
    {
        $billingItem = new BillingItem($data = [
            'first_name' => 'John',
            'last_name' => 'Smith',
            'email_id' => 'foo',
            'company_name' => 'Brightspot',
            'address1' => '102 Decker Ct',
            'address2' => 'Suite 150',
            'postal_code' => 75062,
            'city' => 'Irving',
            'state' => 'TX',
            'countryCode' => 'US',
            'ip_address' => '47.190.18.3'
        ]);

        $this->assertEquals(json_encode($data), $billingItem->toJson());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_first_name()
    {
        $billingItem = new BillingItem([
            'first_name' => 'John'
        ]);

        $this->assertEquals('John', $billingItem->getFirstName());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_last_name()
    {
        $billingItem = new BillingItem([
            'last_name' => 'Smith'
        ]);

        $this->assertEquals('Smith', $billingItem->getLastName());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_an_email_id()
    {
        $billingItem = new BillingItem([
            'email_id' => 'john.smith@brightspot.email'
        ]);

        $this->assertEquals('john.smith@brightspot.email', $billingItem->getEmailId());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_company_name()
    {
        $billingItem = new BillingItem([
            'company_name' => 'Brightspot'
        ]);

        $this->assertEquals('Brightspot', $billingItem->getCompanyName());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_address1()
    {
        $billingItem = new BillingItem([
            'address1' => '102 Decker Ct'
        ]);

        $this->assertEquals('102 Decker Ct', $billingItem->getAddress1());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_address2()
    {
        $billingItem = new BillingItem([
            'address2' => 'Suite 150'
        ]);

        $this->assertEquals('Suite 150', $billingItem->getAddress2());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_city()
    {
        $billingItem = new BillingItem([
            'city' => 'Irving'
        ]);

        $this->assertEquals('Irving', $billingItem->getCity());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_state()
    {
        $billingItem = new BillingItem([
            'state' => 'TX'
        ]);

        $this->assertEquals('TX', $billingItem->getState());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_country_code()
    {
        $billingItem = new BillingItem([
            'countryCode' => 'US'
        ]);

        $this->assertEquals('US', $billingItem->getCountryCode());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_a_country_id()
    {
        $billingItem = new BillingItem([
            'country_id' => 'US'
        ]);

        $this->assertEquals('US', $billingItem->getCountryId());
    }

    /**
     * @test
     */
    public function it_can_set_and_get_an_ip_address()
    {
        $billingItem = new BillingItem([
            'ip_address' => '192.168.1.1'
        ]);

        $this->assertEquals('192.168.1.1', $billingItem->getIpAddress());
    }

    /**
     * @test
     */
    public function it_will_throw_an_exception_when_trying_to_set_invalid_ip_address()
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessageRegExp('/^The IP Address is invalid: 192.168.1.500$/');

        new BillingItem([
            'ip_address' => '192.168.1.500'
        ]);
    }
}
