<?php

namespace Ignite\Vendor\Helix;

use Ignite\Vendor\Helix\Adapters\Guzzle;
use Ignite\Vendor\Helix\Decorators\Json;

final class Factory
{
    /**
     * The list of adapters to lookup.
     *
     * @var array
     */
    private $adapters = [
        'guzzle' => Guzzle::class
    ];

    /**
     * The list of decorators to lookup.
     *
     * @var array
     */
    private $decorators = [
        'json' => Json::class
    ];

    /**
     * Factory constructor.
     *
     * @param array $adapters
     * @param array $decorators
     */
    public function __construct($adapters = [], $decorators = [])
    {
        $this->adapters = array_merge($this->adapters, $adapters);
        $this->decorators = array_merge($this->decorators, $decorators);
    }

    /**
     * Make a new client instance.
     *
     * @param  string $username
     * @param  string $password
     * @param  string $endpoint
     * @param  string $adapter
     * @param  string $decorator
     * @return DecoratorInterface
     */
    public function make($username, $password, $endpoint, $adapter = '', $decorator = '')
    {
        $adapterClass = $this->adapters[$adapter ?: 'guzzle'];
        $decoratorClass = $this->decorators[$decorator ?: 'json'];

        $client = new Client(
            new $adapterClass(
                new Authentication($username, $password, $endpoint)
            )
        );

        return new $decoratorClass($client);
    }
}
