<?php

namespace Ignite\Vendor\Helix;

final class Authentication
{
    /**
     * The user identity to authenticate.
     *
     * @var string
     */
    private $username;

    /**
     * The user credential to authenticate.
     *
     * @var string
     */
    private $password;

    /**
     * The API endpoint to send requests.
     *
     * @var string
     */
    private $endpoint;

    /**
     * Authentication constructor.
     *
     * @param string $username
     * @param string $password
     * @param string $endpoint
     */
    public function __construct($username, $password, $endpoint)
    {
        $this->username = $username;
        $this->password = $password;
        $this->endpoint = $endpoint;
    }

    /**
     * The username credential to authenticate.
     *
     * @return string
     */
    public function username()
    {
        return $this->username;
    }

    /**
     * The password credential to authenticate.
     *
     * @return string
     */
    public function password()
    {
        return $this->password;
    }

    /**
     * The endpoint to send requests to.
     *
     * @return string
     */
    public function endpoint()
    {
        return $this->endpoint;
    }

    /**
     * The base 64 encoded basic authentication token.
     *
     * @return string
     */
    public function token()
    {
        return base64_encode("{$this->username}:{$this->password}");
    }
}
