<?php

namespace Ignite\Vendor\Helix;

use Exception;
use Psr\Http\Message\ResponseInterface;

abstract class AbstractDecorator implements DecoratorInterface
{
    /**
     * The client instance.
     *
     * @var Client
     */
    private $client;

    /**
     * Json constructor.
     *
     * @param ClientInterface $client
     */
    public function __construct(ClientInterface $client)
    {
        $this->client = $client;
    }

    /**
     * Call a magic method on the object.
     *
     * @param  string $name
     * @param  array $arguments
     * @return array|mixed
     * @throws Exception
     */
    public function __call($name, $arguments)
    {
        if (! method_exists($this->client, $name)) {
            throw new Exception("Unknown method $name called on " . static::class);
        }

        return $this->decorate(call_user_func_array([$this->client, $name], $arguments));
    }

    /**
     * Decorate the client response.
     *
     * @param  ResponseInterface $response
     * @return array|mixed
     * @throws Exception
     */
    abstract public function decorate(ResponseInterface $response);
}
