<?php

namespace Ignite\Vendor\Helix\Laravel\Listeners\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\SsoBadLoginUrl;
use Ignite\Vendor\Helix\Laravel\Response;

trait GuardAgainstMissingLoginUrl
{
    /**
     * Guard against a missing or invalid login url.
     *
     * @param Response $response
     *
     * @throws SsoBadLoginUrl
     */
    public function guardAgainstMissingLoginUrl(Response $response)
    {
        if ($response->doesntHaveValue(Response::KEY_SSO_URL)) {
            throw new SsoBadLoginUrl($response, 'Missing Login URL');
        }

        if (! filter_var($response->get(Response::KEY_SSO_URL), FILTER_VALIDATE_URL)) {
            throw new SsoBadLoginUrl($response, 'Invalid Login URL');
        }
    }
}
