<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers;

use Ignite\Vendor\Helix\Laravel\Events\WebhookResourceCreated;
use Ignite\Vendor\Helix\Laravel\Exceptions\InvalidAccessToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\CommonResponses;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\GuardAgainstInvalidToken;
use Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns\TranslatesMessages;
use Ignite\Vendor\Helix\Laravel\Resources\Webhook;
use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;

class WebhookController
{
    use GuardAgainstInvalidToken,
        CommonResponses,
        TranslatesMessages;

    /**
     * Store the points check request.
     *
     * @param Request $request
     * @param Token $tokenService
     *
     * @return JsonResponse
     */
    public function __invoke(Request $request, Token $tokenService)
    {
        $user = $request->json()->get('clientUserId');

        try {
            $hash = md5(Arr::query($request->json()->all()));

            $this->guardAgainstInvalidAccessToken($request, $tokenService);

            $webhook = Webhook::query()->updateOrCreate(compact('hash'), [
                'user_id' => $user,
                'payload' => $request->json()->all(),
                'hash' => $hash
            ]);

            WebhookResourceCreated::dispatch($webhook);

            return $this->successResponse($request, $this->message('webhook.success'));
        } catch (InvalidAccessToken $exception) {
            logger()->error($exception->getMessage(), compact('exception', 'request'));

            return $this->forbiddenResponse($request, $this->message('webhook.forbidden'));
        } catch (\Exception $exception) {
            logger()->error($exception->getMessage(), compact('exception', 'request'));

            return $this->serviceUnavailableResponse($request, $this->message('webhook.unavailable'));
        }
    }
}
