<?php

namespace Ignite\Vendor\Helix\Laravel\Http\Controllers\Concerns;

use Ignite\Vendor\Helix\Laravel\Exceptions\PointsAttributeNotConfigured;

trait RetrievesPointsAttribute
{
    /**
     * The points attribute on the use model.
     *
     * @return string
     * @throws PointsAttributeNotConfigured
     */
    public function getPointsAttribute()
    {
        if (empty($attribute = config('helix.user.attributes.points'))) {
            throw new PointsAttributeNotConfigured();
        }

        return $attribute;
    }
}
