<?php

namespace Ignite\Vendor\Helix\Laravel\Commands;

use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Console\Command;

class DecryptAccessToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'helix:token:decrypt {token}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Decrypt an access token to find out the user.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @param Token $tokenService
     *
     * @return mixed
     */
    public function handle(Token $tokenService)
    {
        $token = $this->argument('token');

        $this->info($tokenService->decrypt($token));
    }
}
