<?php

namespace Ignite\Vendor\Helix\Laravel\Exceptions;

use Ignite\Vendor\Helix\Laravel\Sso\Payload;
use Throwable;

class PayloadUnsupportedCountry extends \Exception
{
    /**
     * @var Payload
     */
    private $payload;

    /**
     * @var null
     */
    private $response;

    /**
     * PayloadUnsupportedCountry constructor.
     *
     * @param Payload $payload
     * @param mixed $response
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($payload, $response = null, $message = "", $code = 0, Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->payload = $payload;
        $this->response = $response;
    }

    /**
     * The data payload sent with the SSO request.
     *
     * @return Payload
     */
    public function getPayload()
    {
        return $this->payload;
    }

    /**
     * The response from the SSO request.
     *
     * @return mixed
     */
    public function getResponse()
    {
        return $this->response;
    }
}
