<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Http\Views\Composers;

use Ignite\Vendor\Helix\Laravel\Http\Views\Composers\IframeComposer;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class IframeComposerTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_share_whether_the_session_value_exists()
    {
        session()->put(config('helix.sso.session.key'), null);

        /** @var \Illuminate\View\View $view */
        $view = view('helix::catalog.iframe');

        $composer = new IframeComposer();

        $composer->compose($view);

        $this->assertFalse($view->sessionExists);

        session()->put(config('helix.sso.session.key'), 'foo');

        $composer->compose($view);

        $this->assertTrue($view->sessionExists);
    }

    /**
     * @test
     */
    public function it_will_validate_the_url_in_the_session()
    {
        session()->put(config('helix.sso.session.key'), 'not a real url');

        /** @var \Illuminate\View\View $view */
        $view = view('helix::catalog.iframe');

        $composer = new IframeComposer();

        $composer->compose($view);

        $this->assertFalse($view->url);
    }

    /**
     * @test
     */
    public function it_will_validate_and_pass_a_valid_url_to_the_view()
    {
        $url = 'https://brightspot.helixgs.com/foo/abcdefghijklmnopqstuvxw';

        session()->put(config('helix.sso.session.key'), $url);

        /** @var \Illuminate\View\View $view */
        $view = view('helix::catalog.iframe');

        $composer = new IframeComposer();

        $composer->compose($view);

        $this->assertEquals($url, $view->url);
    }
}
