<?php

namespace Ignite\Vendor\Helix\Laravel\Exceptions;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\MessageBag;
use Throwable;

class PayloadValidationFailed extends \Exception
{
    /**
     * @var MessageBag
     */
    protected $errors;

    /**
     * PayloadValidationFailed constructor.
     *
     * @param MessageBag $errors
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct(MessageBag $errors, $message = "", $code = 0, ?Throwable $previous = null)
    {
        $this->errors = $errors;
        $message = ($message ?: "{$errors->count()} validation error(s)");
        // add extra details in the message so it can show in Flare
        // and not have to check the log files manually.
        $message .= ': ' . json_encode($this->errors->getMessages());

        parent::__construct($message, $code, $previous);
    }

    /**
     * The failed validation errors.
     *
     * @return MessageBag
     */
    public function getErrors()
    {
        return $this->errors;
    }
}
