<?php

namespace Ignite\Vendor\Helix\Laravel\Exceptions;

use Throwable;

class OpenSslCipherNotSupported extends \Exception
{
    /**
     * @var string
     */
    private $cipher;

    /**
     * InvalidAccessToken constructor.
     *
     * @param string $cipher
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($cipher, $message = "", $code = 0, ?Throwable $previous = null)
    {
        $message = empty($message) ? "Cipher $cipher is not supported by your environment." : $message;
        $this->cipher = $cipher;
        parent::__construct($message, $code, $previous);
    }
}
