<?php

namespace Ignite\Vendor\Helix\Laravel\Exceptions;

use Throwable;

class InvalidAccessToken extends \Exception
{
    /**
     * @var string
     */
    private $accessToken;

    /**
     * InvalidAccessToken constructor.
     *
     * @param string $accessToken
     * @param string $message
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($accessToken, $message = "", $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->accessToken = $accessToken;
    }
}
