<?php

namespace Ignite\Vendor\Helix\Laravel\Commands;

use Ignite\Vendor\Helix\Laravel\Services\Token;
use Illuminate\Console\Command;

class EncryptAccessToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'helix:token:encrypt {user}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Encrypt a user access token.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @param Token $tokenService
     *
     * @return mixed
     */
    public function handle(Token $tokenService)
    {
        $catalogToken = config('helix.token.catalog');
        $userId = $this->argument('user');

        $this->info($tokenService->encrypt($catalogToken, $userId));
    }
}
