<?php

namespace Ignite\Vendor\Helix\Laravel\Tests\Unit\Http\Views\Composers;

use Ignite\Vendor\Helix\Laravel\Http\Views\Composers\ScriptComposer;
use Ignite\Vendor\Helix\Laravel\Tests\TestCase;

class ScriptComposerTest extends TestCase
{
    /**
     * @test
     */
    public function it_will_share_the_helix_sso_endpoint_with_the_script_view_so_it_can_target_a_domain()
    {
        $endpoint = config('helix.sso.endpoint');

        /** @var \Illuminate\View\View $view */
        $view = view('helix::catalog.script');

        $composer = new ScriptComposer();

        $composer->compose($view);

        $this->assertEquals($endpoint, $view->target);
    }
}
